#include <bits/stdc++.h>

using namespace std;

typedef long long ll;
typedef long double ld;

#define sz(x) ((int) (x).size())
#define pb push_back
#define mp make_pair
#define fi first
#define se second

#define NAME "k"

int x[100001];
int y[100001];
vector <int> g[100001];
vector <int> G[100001];
int n;
ld cost[100001];
ld ANS;

typedef complex <ld> point;

ld angle(int u, int v, int w)
{
	point U(x[u], y[u]);
	point V(x[v], y[v]);
	point W(x[w], y[w]);
	point A = V - U;
	point B = W - V;
	B /= A;
	return fabsl(arg(B));
}

pair <ld, int> best;

void check(int u, int a, int b, int c, int d, int id)
{
	ld ang = angle(a, u, b) + angle(c, u, d);
	best = min(best, mp(ang, id));
}

map <pair <int, int>, int> conv;

int get_id(pair <int, int> ed)
{
	if (ed.se < ed.fi)
		swap(ed.fi, ed.se);
	if (conv.count(ed))
		return conv[ed];
	return conv[ed] = conv.size();
}

int col[100001];

int get(int u)
{
	return u == col[u] ? u : col[u] = get(col[u]);
}

bool join(int u, int v)
{
	u = get(u), v = get(v);
	if (u == v)
		return false;
	col[u] = v;
	return true;
}

inline void add_edge(int u, int v, int w)
{
//	cerr << u << ' ' << v << ' ' << w << '\n';
	join(get_id(mp(u, v)), get_id(mp(v, w)));
}

void build_best(int u)
{
	if (sz(g[u]) == 2)
	{
		add_edge(g[u][0], u, g[u][1]);
		ANS += angle(g[u][0], u, g[u][1]);
		return;
	}
	best = mp(1e18, -1);
	check(u, g[u][0], g[u][1], g[u][2], g[u][3], 1);
	check(u, g[u][0], g[u][2], g[u][1], g[u][3], 2);
	check(u, g[u][0], g[u][3], g[u][2], g[u][1], 3);
	assert(best.se != -1);
	ld badness = best.fi;
	ANS += badness;
	int id = best.se;
	add_edge(g[u][0], u, g[u][id]);
	vector <int> other(0);
	for (int i = 1; i < 4; ++i)
		if (i != id)
			other.pb(i);
	add_edge(g[u][other[0]], u, g[u][other[1]]);
	best = mp(1e18, -1);
	if (id != 1)
		check(u, g[u][0], g[u][1], g[u][2], g[u][3], 1);
	if (id != 2)
		check(u, g[u][0], g[u][2], g[u][1], g[u][3], 2);
	if (id != 3)
		check(u, g[u][0], g[u][3], g[u][2], g[u][1], 3);
	assert(best.se != -1);
	ld new_badness = best.fi;
//	cerr << u << ' ' << new_badness << ' ' << badness << '\n';
	cost[u] = new_badness - badness;
}

struct update
{
	int u, v;
	ld w;
	
	update(int u, int v, ld w): u(u), v(v), w(w) {}
	
	bool operator<(const update &upd) const
	{
		return w < upd.w;
	}
	
};

vector <update> upd;

int main()
{
	cout.precision(10);
	cout.setf(ios::fixed);
	#ifdef LOCAL
	assert(freopen(NAME ".in", "r", stdin));
	#endif // LOCAL
	for (int i = 0; i < 100001; ++i)
		col[i] = i;
	int m;
	cin >> n >> m;
	for (int i = 0; i < n; ++i)
		cin >> x[i] >> y[i];
	for (int i = 0; i < m; ++i)
	{
		int u, v;
		cin >> u >> v;
		g[u].pb(v), g[v].pb(u);
	}
	for (int i = 0; i < n; ++i)
	{
		assert(sz(g[i]) == 2 || sz(g[i]) == 4);
		build_best(i);
	}
	for (int u = 0; u < n; ++u)
	{
		if (sz(g[u]) == 2)
			continue;
		int id = get_id(mp(u, g[u][0]));
		for (int i = 1; i < 4; ++i)
		{
			int id2 = get_id(mp(u, g[u][i]));
			if (get(id) != get(id2))
			{
				upd.pb(update(id, id2, cost[u]));
			}
		}
	}
	sort(upd.begin(), upd.end());
	for (int i = 0; i < sz(upd); ++i)
	{
		if (join(upd[i].u, upd[i].v))
			ANS += upd[i].w;
	}
	cout << ANS << '\n';
	#ifdef LOCAL
	cerr << "Time: " << double(clock()) / CLOCKS_PER_SEC << "\n";
	#endif // LOCAL
	return 0;
}
